<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp\Psr7;

class Request implements \Psr\Http\Message\RequestInterface
{
    use MessageTrait;
    private $method;
    private $requestTarget;
    private $uri;
    public function __construct($method, $uri, array $headers = [], $body = NULL, $version = "1.1")
    {
        $this->assertMethod($method);
        if(!$uri instanceof \Psr\Http\Message\UriInterface) {
            $uri = new Uri($uri);
        }
        $this->method = strtoupper($method);
        $this->uri = $uri;
        $this->setHeaders($headers);
        $this->protocol = $version;
        if(!isset($this->headerNames["host"])) {
            $this->updateHostFromUri();
        }
        if($body !== "" && $body !== NULL) {
            $this->stream = stream_for($body);
        }
    }
    public function getRequestTarget()
    {
        if($this->requestTarget !== NULL) {
            return $this->requestTarget;
        }
        $target = $this->uri->getPath();
        if($target == "") {
            $target = "/";
        }
        if($this->uri->getQuery() != "") {
            $target .= "?" . $this->uri->getQuery();
        }
        return $target;
    }
    public function withRequestTarget($requestTarget)
    {
        if(preg_match("#\\s#", $requestTarget)) {
            throw new \InvalidArgumentException("Invalid request target provided; cannot contain whitespace");
        }
        $new = clone $this;
        $new->requestTarget = $requestTarget;
        return $new;
    }
    public function getMethod()
    {
        return $this->method;
    }
    public function withMethod($method)
    {
        $this->assertMethod($method);
        $new = clone $this;
        $new->method = strtoupper($method);
        return $new;
    }
    public function getUri()
    {
        return $this->uri;
    }
    public function withUri(\Psr\Http\Message\UriInterface $uri, $preserveHost = false)
    {
        if($uri === $this->uri) {
            return $this;
        }
        $new = clone $this;
        $new->uri = $uri;
        if(!$preserveHost || !isset($this->headerNames["host"])) {
            $new->updateHostFromUri();
        }
        return $new;
    }
    private function updateHostFromUri()
    {
        $host = $this->uri->getHost();
        if($host == "") {
            return NULL;
        }
        if(($port = $this->uri->getPort()) !== NULL) {
            $host .= ":" . $port;
        }
        if(isset($this->headerNames["host"])) {
            $header = $this->headerNames["host"];
        } else {
            $header = "Host";
            $this->headerNames["host"] = "Host";
        }
        $this->headers = [$header => [$host]] + $this->headers;
    }
    private function assertMethod($method)
    {
        if(!is_string($method) || $method === "") {
            throw new \InvalidArgumentException("Method must be a non-empty string.");
        }
    }
}

?>