<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp\Psr7;

class PumpStream implements \Psr\Http\Message\StreamInterface
{
    private $source;
    private $size;
    private $tellPos = 0;
    private $metadata;
    private $buffer;
    public function __construct(callable $source, array $options = [])
    {
        $this->source = $source;
        $this->size = isset($options["size"]) ? $options["size"] : NULL;
        $this->metadata = isset($options["metadata"]) ? $options["metadata"] : [];
        $this->buffer = new BufferStream();
    }
    public function __toString()
    {
        try {
            return copy_to_string($this);
        } catch (\Exception $e) {
            return "";
        }
    }
    public function close()
    {
        $this->detach();
    }
    public function detach()
    {
        $this->tellPos = false;
        $this->source = NULL;
    }
    public function getSize()
    {
        return $this->size;
    }
    public function tell()
    {
        return $this->tellPos;
    }
    public function eof()
    {
        return !$this->source;
    }
    public function isSeekable()
    {
        return false;
    }
    public function rewind()
    {
        $this->seek(0);
    }
    public function seek($offset, $whence = SEEK_SET)
    {
        throw new \RuntimeException("Cannot seek a PumpStream");
    }
    public function isWritable()
    {
        return false;
    }
    public function write($string)
    {
        throw new \RuntimeException("Cannot write to a PumpStream");
    }
    public function isReadable()
    {
        return true;
    }
    public function read($length)
    {
        $data = $this->buffer->read($length);
        $readLen = strlen($data);
        $this->tellPos += $readLen;
        $remaining = $length - $readLen;
        if($remaining) {
            $this->pump($remaining);
            $data .= $this->buffer->read($remaining);
            $this->tellPos += strlen($data) - $readLen;
        }
        return $data;
    }
    public function getContents()
    {
        $result = "";
        while (!$this->eof()) {
            $result .= $this->read(1000000);
        }
        return $result;
    }
    public function getMetadata($key = NULL)
    {
        if(!$key) {
            return $this->metadata;
        }
        return isset($this->metadata[$key]) ? $this->metadata[$key] : NULL;
    }
    private function pump($length)
    {
        if($this->source) {
            $data = call_user_func($this->source, $length);
            if($data === false || $data === NULL) {
                $this->source = NULL;
                return NULL;
            }
            $this->buffer->write($data);
            $length -= strlen($data);
            if(0 < $length) {
            }
        }
    }
}

?>