<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp\Psr7;

class LimitStream implements \Psr\Http\Message\StreamInterface
{
    use StreamDecoratorTrait;
    private $offset;
    private $limit;
    public function __construct(\Psr\Http\Message\StreamInterface $stream, $limit = -1, $offset = 0)
    {
        $this->stream = $stream;
        $this->setLimit($limit);
        $this->setOffset($offset);
    }
    public function eof()
    {
        if($this->stream->eof()) {
            return true;
        }
        if($this->limit == -1) {
            return false;
        }
        return $this->offset + $this->limit <= $this->stream->tell();
    }
    public function getSize()
    {
        if(NULL === ($length = $this->stream->getSize())) {
            return NULL;
        }
        if($this->limit == -1) {
            return $length - $this->offset;
        }
        return min($this->limit, $length - $this->offset);
    }
    public function seek($offset, $whence = SEEK_SET)
    {
        if($whence !== SEEK_SET || $offset < 0) {
            throw new \RuntimeException(sprintf("Cannot seek to offset %s with whence %s", $offset, $whence));
        }
        $offset += $this->offset;
        if($this->limit !== -1 && $this->offset + $this->limit < $offset) {
            $offset = $this->offset + $this->limit;
        }
        $this->stream->seek($offset);
    }
    public function tell()
    {
        return $this->stream->tell() - $this->offset;
    }
    public function setOffset($offset)
    {
        $current = $this->stream->tell();
        if($current !== $offset) {
            if($this->stream->isSeekable()) {
                $this->stream->seek($offset);
            } else {
                if($offset < $current) {
                    throw new \RuntimeException("Could not seek to stream offset " . $offset);
                }
                $this->stream->read($offset - $current);
            }
        }
        $this->offset = $offset;
    }
    public function setLimit($limit)
    {
        $this->limit = $limit;
    }
    public function read($length)
    {
        if($this->limit == -1) {
            return $this->stream->read($length);
        }
        $remaining = $this->offset + $this->limit - $this->stream->tell();
        if(0 < $remaining) {
            return $this->stream->read(min($remaining, $length));
        }
        return "";
    }
}

?>