<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp\Psr7;

class InflateStream implements \Psr\Http\Message\StreamInterface
{
    use StreamDecoratorTrait;
    public function __construct(\Psr\Http\Message\StreamInterface $stream)
    {
        $header = $stream->read(10);
        $filenameHeaderLength = $this->getLengthOfPossibleFilenameHeader($stream, $header);
        $stream = new LimitStream($stream, -1, 10 + $filenameHeaderLength);
        $resource = StreamWrapper::getResource($stream);
        stream_filter_append($resource, "zlib.inflate", STREAM_FILTER_READ);
        $this->stream = $stream->isSeekable() ? new Stream($resource) : new NoSeekStream(new Stream($resource));
    }
    private function getLengthOfPossibleFilenameHeader(\Psr\Http\Message\StreamInterface $stream, $header)
    {
        $filename_header_length = 0;
        if(substr(bin2hex($header), 6, 2) === "08") {
            for ($filename_header_length = 1; $stream->read(1) !== chr(0); $filename_header_length++) {
            }
        }
        return $filename_header_length;
    }
}

?>