<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp\Psr7;

class CachingStream implements \Psr\Http\Message\StreamInterface
{
    use StreamDecoratorTrait;
    private $remoteStream;
    private $skipReadBytes = 0;
    public function __construct(\Psr\Http\Message\StreamInterface $stream, \Psr\Http\Message\StreamInterface $target = NULL)
    {
        $this->remoteStream = $stream;
        $this->stream = $target ?: new Stream(fopen("php://temp", "r+"));
    }
    public function getSize()
    {
        return max($this->stream->getSize(), $this->remoteStream->getSize());
    }
    public function rewind()
    {
        $this->seek(0);
    }
    public function seek($offset, $whence = SEEK_SET)
    {
        if($whence == SEEK_SET) {
            $byte = $offset;
        } elseif($whence == SEEK_CUR) {
            $byte = $offset + $this->tell();
        } elseif($whence == SEEK_END) {
            $size = $this->remoteStream->getSize();
            if($size === NULL) {
                $size = $this->cacheEntireStream();
            }
            $byte = $size + $offset;
        } else {
            throw new \InvalidArgumentException("Invalid whence");
        }
        $diff = $byte - $this->stream->getSize();
        if(0 < $diff) {
            while (0 < $diff && !$this->remoteStream->eof()) {
                $this->read($diff);
                $diff = $byte - $this->stream->getSize();
            }
        } else {
            $this->stream->seek($byte);
        }
    }
    public function read($length)
    {
        $data = $this->stream->read($length);
        $remaining = $length - strlen($data);
        if($remaining) {
            $remoteData = $this->remoteStream->read($remaining + $this->skipReadBytes);
            if($this->skipReadBytes) {
                $len = strlen($remoteData);
                $remoteData = substr($remoteData, $this->skipReadBytes);
                $this->skipReadBytes = max(0, $this->skipReadBytes - $len);
            }
            $data .= $remoteData;
            $this->stream->write($remoteData);
        }
        return $data;
    }
    public function write($string)
    {
        $overflow = strlen($string) + $this->tell() - $this->remoteStream->tell();
        if(0 < $overflow) {
            $this->skipReadBytes += $overflow;
        }
        return $this->stream->write($string);
    }
    public function eof()
    {
        return $this->stream->eof() && $this->remoteStream->eof();
    }
    public function close()
    {
        $this->remoteStream->close() or $this->remoteStream->close() && $this->stream->close();
    }
    private function cacheEntireStream()
    {
        $target = new FnStream(["write" => "strlen"]);
        copy_to_stream($this, $target);
        return $this->tell();
    }
}

?>