<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp\Promise;

class Promise implements PromiseInterface
{
    private $state = self::PENDING;
    private $result;
    private $cancelFn;
    private $waitFn;
    private $waitList;
    private $handlers = [];
    public function __construct(callable $waitFn = NULL, callable $cancelFn = NULL)
    {
        $this->waitFn = $waitFn;
        $this->cancelFn = $cancelFn;
    }
    public function then(callable $onFulfilled = NULL, callable $onRejected = NULL)
    {
        if($this->state === self::PENDING) {
            $p = new Promise(NULL, [$this, "cancel"]);
            $this->handlers[] = [$p, $onFulfilled, $onRejected];
            $p->waitList = $this->waitList;
            $p->waitList[] = $this;
            return $p;
        }
        if($this->state === self::FULFILLED) {
            return $onFulfilled ? promise_for($this->result)->then($onFulfilled) : promise_for($this->result);
        }
        $rejection = rejection_for($this->result);
        return $onRejected ? $rejection->then(NULL, $onRejected) : $rejection;
    }
    public function otherwise(callable $onRejected)
    {
        return $this->then(NULL, $onRejected);
    }
    public function wait($unwrap = true)
    {
        $this->waitIfPending();
        $inner = $this->result instanceof PromiseInterface ? $this->result->wait($unwrap) : $this->result;
        if($unwrap) {
            if($this->result instanceof PromiseInterface || $this->state === self::FULFILLED) {
                return $inner;
            }
            throw exception_for($inner);
        }
    }
    public function getState()
    {
        return $this->state;
    }
    public function cancel()
    {
        if($this->state !== self::PENDING) {
            return NULL;
        }
        $this->waitFn = $this->waitList = NULL;
        if($this->cancelFn) {
            $fn = $this->cancelFn;
            $this->cancelFn = NULL;
            try {
                $fn();
            } catch (\Throwable $e) {
                $this->reject($e);
            } catch (\Exception $e) {
                $this->reject($e);
            }
        }
        if($this->state === self::PENDING) {
            $this->reject(new CancellationException("Promise has been cancelled"));
        }
    }
    public function resolve($value)
    {
        $this->settle(self::FULFILLED, $value);
    }
    public function reject($reason)
    {
        $this->settle(self::REJECTED, $reason);
    }
    private function settle($state, $value)
    {
        if($this->state !== self::PENDING) {
            if($state === $this->state && $value === $this->result) {
                return NULL;
            }
            throw $this->state === $state ? new \LogicException("The promise is already " . $state . ".") : new \LogicException("Cannot change a " . $this->state . " promise to " . $state);
        }
        if($value === $this) {
            throw new \LogicException("Cannot fulfill or reject a promise with itself");
        }
        $this->state = $state;
        $this->result = $value;
        $handlers = $this->handlers;
        $this->handlers = NULL;
        $this->waitList = $this->waitFn = NULL;
        $this->cancelFn = NULL;
        if(!$handlers) {
            return NULL;
        }
        if(!method_exists($value, "then")) {
            $id = $state === self::FULFILLED ? 1 : 2;
            queue()->add(function () {
                static $id = NULL;
                static $value = NULL;
                static $handlers = NULL;
                foreach ($handlers as $handler) {
                    self::callHandler($id, $value, $handler);
                }
            });
        } elseif($value instanceof Promise && $value->getState() === self::PENDING) {
            $value->handlers = array_merge($value->handlers, $handlers);
        } else {
            $value->then(function ($value) {
                static $handlers = NULL;
                foreach ($handlers as $handler) {
                    self::callHandler(1, $value, $handler);
                }
            }, function ($reason) {
                static $handlers = NULL;
                foreach ($handlers as $handler) {
                    self::callHandler(2, $reason, $handler);
                }
            });
        }
    }
    private static function callHandler($index, $value, array $handler)
    {
        $promise = $handler[0];
        if($promise->getState() !== self::PENDING) {
            return NULL;
        }
        try {
            if(isset($handler[$index])) {
                $promise->resolve($handler[$index]($value));
            } elseif($index === 1) {
                $promise->resolve($value);
            } else {
                $promise->reject($value);
            }
        } catch (\Throwable $reason) {
            $promise->reject($reason);
        } catch (\Exception $reason) {
            $promise->reject($reason);
        }
    }
    private function waitIfPending()
    {
        if($this->state !== self::PENDING) {
            return NULL;
        }
        if($this->waitFn) {
            $this->invokeWaitFn();
        } elseif($this->waitList) {
            $this->invokeWaitList();
        } else {
            $this->reject("Cannot wait on a promise that has no internal wait function. You must provide a wait function when constructing the promise to be able to wait on a promise.");
        }
        queue()->run();
        if($this->state === self::PENDING) {
            $this->reject("Invoking the wait callback did not resolve the promise");
        }
    }
    private function invokeWaitFn()
    {
        try {
            $wfn = $this->waitFn;
            $this->waitFn = NULL;
            $wfn(true);
        } catch (\Exception $reason) {
            if($this->state === self::PENDING) {
                $this->reject($reason);
            } else {
                throw $reason;
            }
        }
    }
    private function invokeWaitList()
    {
        $waitList = $this->waitList;
        $this->waitList = NULL;
        foreach ($waitList as $result) {
            while (true) {
                $result->waitIfPending();
                if($result->result instanceof Promise) {
                    $result = $result->result;
                    break;
                }
                if($result->result instanceof PromiseInterface) {
                    $result->result->wait(false);
                }
            }
        }
    }
}

?>