<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp\Promise;

class FulfilledPromise implements PromiseInterface
{
    private $value;
    public function __construct($value)
    {
        if(method_exists($value, "then")) {
            throw new \InvalidArgumentException("You cannot create a FulfilledPromise with a promise.");
        }
        $this->value = $value;
    }
    public function then(callable $onFulfilled = NULL, callable $onRejected = NULL)
    {
        if(!$onFulfilled) {
            return $this;
        }
        $queue = queue();
        $p = new Promise([$queue, "run"]);
        $value = $this->value;
        $queue->add(function () {
            static $p = NULL;
            static $value = NULL;
            static $onFulfilled = NULL;
            if($p->getState() === self::PENDING) {
                try {
                    $p->resolve($onFulfilled($value));
                } catch (\Throwable $e) {
                    $p->reject($e);
                } catch (\Exception $e) {
                    $p->reject($e);
                }
            }
        });
        return $p;
    }
    public function otherwise(callable $onRejected)
    {
        return $this->then(NULL, $onRejected);
    }
    public function wait($unwrap = true, $defaultDelivery = NULL)
    {
        return $unwrap ? $this->value : NULL;
    }
    public function getState()
    {
        return self::FULFILLED;
    }
    public function resolve($value)
    {
        if($value !== $this->value) {
            throw new \LogicException("Cannot resolve a fulfilled promise");
        }
    }
    public function reject($reason)
    {
        throw new \LogicException("Cannot reject a fulfilled promise");
    }
    public function cancel()
    {
    }
}

?>