<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp;

function uri_template($template, array $variables)
{
    if(extension_loaded("uri_template")) {
        return uri_template($template, $variables);
    }
    static $uriTemplate = NULL;
    if(!$uriTemplate) {
        $uriTemplate = new UriTemplate();
    }
    return $uriTemplate->expand($template, $variables);
}
function describe_type($input)
{
    gettype($input);
    switch (gettype($input)) {
        case "object":
            return "object(" . get_class($input) . ")";
            break;
        case "array":
            return "array(" . count($input) . ")";
            break;
        default:
            ob_start();
            var_dump($input);
            return str_replace("double(", "float(", rtrim(ob_get_clean()));
    }
}
function headers_from_lines($lines)
{
    $headers = [];
    foreach ($lines as $line) {
        $parts = explode(":", $line, 2);
        $headers[trim($parts[0])][] = isset($parts[1]) ? trim($parts[1]) : NULL;
    }
    return $headers;
}
function debug_resource($value = NULL)
{
    if(is_resource($value)) {
        return $value;
    }
    if(defined("STDOUT")) {
        return STDOUT;
    }
    return fopen("php://output", "w");
}
function choose_handler()
{
    $handler = NULL;
    if(function_exists("curl_multi_exec") && function_exists("curl_exec")) {
        $handler = Handler\Proxy::wrapSync(new Handler\CurlMultiHandler(), new Handler\CurlHandler());
    } elseif(function_exists("curl_exec")) {
        $handler = new Handler\CurlHandler();
    } elseif(function_exists("curl_multi_exec")) {
        $handler = new Handler\CurlMultiHandler();
    }
    if(ini_get("allow_url_fopen")) {
        $handler = $handler ? Handler\Proxy::wrapStreaming($handler, new Handler\StreamHandler()) : new Handler\StreamHandler();
    } elseif(!$handler) {
        throw new \RuntimeException("GuzzleHttp requires cURL, the allow_url_fopen ini setting, or a custom HTTP handler.");
    }
    return $handler;
}
function default_user_agent()
{
    static $defaultAgent = "";
    if(!$defaultAgent) {
        $defaultAgent = "GuzzleHttp/" . Client::VERSION;
        if(extension_loaded("curl") && function_exists("curl_version")) {
            $defaultAgent .= " curl/" . curl_version()["version"];
        }
        $defaultAgent .= " PHP/" . PHP_VERSION;
    }
    return $defaultAgent;
}
function default_ca_bundle()
{
    static $cached = NULL;
    static $cafiles = ["/etc/pki/tls/certs/ca-bundle.crt", "/etc/ssl/certs/ca-certificates.crt", "/usr/local/share/certs/ca-root-nss.crt", "/var/lib/ca-certificates/ca-bundle.pem", "/usr/local/etc/openssl/cert.pem", "/etc/ca-certificates.crt", "C:\\windows\\system32\\curl-ca-bundle.crt", "C:\\windows\\curl-ca-bundle.crt"];
    if($cached) {
        return $cached;
    }
    if($ca = ini_get("openssl.cafile")) {
        return $cached = $ca;
    }
    if($ca = ini_get("curl.cainfo")) {
        return $cached = $ca;
    }
    foreach ($cafiles as $filename) {
        if(file_exists($filename)) {
            return $cached = $filename;
        }
    }
    throw new \RuntimeException("No system CA bundle could be found in any of the the common system locations.\nPHP versions earlier than 5.6 are not properly configured to use the system's\nCA bundle by default. In order to verify peer certificates, you will need to\nsupply the path on disk to a certificate bundle to the 'verify' request\noption: http://docs.guzzlephp.org/en/latest/clients.html#verify. If you do not\nneed a specific certificate bundle, then Mozilla provides a commonly used CA\nbundle which can be downloaded here (provided by the maintainer of cURL):\nhttps://raw.githubusercontent.com/bagder/ca-bundle/master/ca-bundle.crt. Once\nyou have a CA bundle available on disk, you can set the 'openssl.cafile' PHP\nini setting to point to the path to the file, allowing you to omit the 'verify'\nrequest option. See http://curl.haxx.se/docs/sslcerts.html for more\ninformation.");
}
function normalize_header_keys(array $headers)
{
    $result = [];
    foreach (array_keys($headers) as $key) {
        $result[strtolower($key)] = $key;
    }
    return $result;
}
function is_host_in_noproxy($host, array $noProxyArray)
{
    if(strlen($host) === 0) {
        throw new \InvalidArgumentException("Empty host provided");
    }
    if(strpos($host, ":")) {
        list($host) = explode($host, ":", 2);
    }
    foreach ($noProxyArray as $area) {
        if($area === "*") {
            return true;
        }
        if(empty($area)) {
        } else {
            if($area === $host) {
                return true;
            }
            $area = "." . ltrim($area, ".");
            if(substr($host, -1 * strlen($area)) === $area) {
                return true;
            }
        }
    }
    return false;
}
function json_decode($json, $assoc = false, $depth = 512, $options = 0)
{
    $data = json_decode($json, $assoc, $depth, $options);
    if(JSON_ERROR_NONE !== json_last_error()) {
        throw new Exception\InvalidArgumentException("json_decode error: " . json_last_error_msg());
    }
    return $data;
}
function json_encode($value, $options = 0, $depth = 512)
{
    $json = json_encode($value, $options, $depth);
    if(JSON_ERROR_NONE !== json_last_error()) {
        throw new Exception\InvalidArgumentException("json_encode error: " . json_last_error_msg());
    }
    return $json;
}
function _current_time()
{
    return function_exists("hrtime") ? hrtime(true) / 0 : microtime(true);
}

?>