<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp;

class RetryMiddleware
{
    private $nextHandler;
    private $decider;
    private $delay;
    public function __construct(callable $decider, callable $nextHandler, callable $delay = NULL)
    {
        $this->decider = $decider;
        $this->nextHandler = $nextHandler;
        $this->delay = $delay ?: "RetryMiddleware::exponentialDelay";
    }
    public static function exponentialDelay($retries)
    {
        return (int) pow(2, $retries - 1);
    }
    public function __invoke(\Psr\Http\Message\RequestInterface $request, array $options)
    {
        if(!isset($options["retries"])) {
            $options["retries"] = 0;
        }
        $fn = $this->nextHandler;
        return $fn($request, $options)->then($this->onFulfilled($request, $options), $this->onRejected($request, $options));
    }
    private function onFulfilled(\Psr\Http\Message\RequestInterface $req, array $options)
    {
        return function ($value) {
            static $req = NULL;
            static $options = NULL;
            if(!call_user_func($this->decider, $options["retries"], $req, $value, NULL)) {
                return $value;
            }
            return $this->doRetry($req, $options, $value);
        };
    }
    private function onRejected(\Psr\Http\Message\RequestInterface $req, array $options)
    {
        return function ($reason) {
            static $req = NULL;
            static $options = NULL;
            if(!call_user_func($this->decider, $options["retries"], $req, NULL, $reason)) {
                return Promise\rejection_for($reason);
            }
            return $this->doRetry($req, $options);
        };
    }
    private function doRetry(\Psr\Http\Message\RequestInterface $request, array $options, \Psr\Http\Message\ResponseInterface $response = NULL)
    {
        $options["delay"] = call_user_func($this->delay, ++$options["retries"], $response);
        return $this($request, $options);
    }
}

?>