<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp;

class PrepareBodyMiddleware
{
    private $nextHandler;
    public function __construct(callable $nextHandler)
    {
        $this->nextHandler = $nextHandler;
    }
    public function __invoke(\Psr\Http\Message\RequestInterface $request, array $options)
    {
        $fn = $this->nextHandler;
        if($request->getBody()->getSize() === 0) {
            return $fn($request, $options);
        }
        $modify = [];
        if(!$request->hasHeader("Content-Type") && ($uri = $request->getBody()->getMetadata("uri")) && ($type = mimetype_from_filename($uri))) {
            $modify["set_headers"]["Content-Type"] = $type;
        }
        if(!$request->hasHeader("Content-Length") && !$request->hasHeader("Transfer-Encoding")) {
            $size = $request->getBody()->getSize();
            if($size !== NULL) {
                $modify["set_headers"]["Content-Length"] = $size;
            } else {
                $modify["set_headers"]["Transfer-Encoding"] = "chunked";
            }
        }
        $this->addExpectHeader($request, $options, $modify);
        return $fn(Psr7\modify_request($request, $modify), $options);
    }
    private function addExpectHeader(\Psr\Http\Message\RequestInterface $request, array $options, array &$modify)
    {
        if($request->hasHeader("Expect")) {
            return NULL;
        }
        $expect = isset($options["expect"]) ? $options["expect"] : NULL;
        if($expect === false || $request->getProtocolVersion() < 0) {
            return NULL;
        }
        if($expect === true) {
            $modify["set_headers"]["Expect"] = "100-Continue";
        } else {
            if($expect === NULL) {
                $expect = 1048576;
            }
            $body = $request->getBody();
            $size = $body->getSize();
            if($size === NULL || (int) $expect <= $size || !$body->isSeekable()) {
                $modify["set_headers"]["Expect"] = "100-Continue";
            }
        }
    }
}

?>