<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp;

class Pool implements Promise\PromisorInterface
{
    private $each;
    public function __construct(ClientInterface $client, $requests, array $config = [])
    {
        if(isset($config["pool_size"])) {
            $config["concurrency"] = $config["pool_size"];
        } elseif(!isset($config["concurrency"])) {
            $config["concurrency"] = 25;
        }
        if(isset($config["options"])) {
            $opts = $config["options"];
            unset($config["options"]);
        } else {
            $opts = [];
        }
        $iterable = Promise\iter_for($requests);
        $requests = function () {
            static $iterable = NULL;
            static $client = NULL;
            static $opts = NULL;
            foreach ($iterable as $key => $rfn) {
                if($rfn instanceof \Psr\Http\Message\RequestInterface) {
                    yield $client->sendAsync($rfn, $opts);
                } elseif(is_callable($rfn)) {
                    yield $rfn($opts);
                } else {
                    throw new \InvalidArgumentException("Each value yielded by the iterator must be a Psr7\\Http\\Message\\RequestInterface or a callable that returns a promise that fulfills with a Psr7\\Message\\Http\\ResponseInterface object.");
                }
            }
        };
        $this->each = new Promise\EachPromise($requests(), $config);
    }
    public function promise()
    {
        return $this->each->promise();
    }
    public static function batch(ClientInterface $client, $requests, array $options = [])
    {
        $res = [];
        self::cmpCallback($options, "fulfilled", $res);
        self::cmpCallback($options, "rejected", $res);
        $pool = new static($client, $requests, $options);
        $pool->promise()->wait();
        ksort($res);
        return $res;
    }
    private static function cmpCallback(array &$options, $name, array &$results)
    {
        if(!isset($options[$name])) {
            $options[$name] = function ($v, $k) {
                static $results = NULL;
                $results[$k] = $v;
            };
        } else {
            $currentFn = $options[$name];
            $options[$name] = function ($v, $k) {
                static $results = NULL;
                static $currentFn = NULL;
                $currentFn($v, $k);
                $results[$k] = $v;
            };
        }
    }
}

?>