<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp;

class Middleware
{
    public static function cookies()
    {
        return function (callable $handler) {
            return function ($request, array $options) {
                static $handler = NULL;
                if(empty($options["cookies"])) {
                    return $handler($request, $options);
                }
                if(!$options["cookies"] instanceof Cookie\CookieJarInterface) {
                    throw new \InvalidArgumentException("cookies must be an instance of Cookie\\CookieJarInterface");
                }
                $cookieJar = $options["cookies"];
                $request = $cookieJar->withCookieHeader($request);
                return $handler($request, $options)->then(function ($response) {
                    static $cookieJar = NULL;
                    static $request = NULL;
                    $cookieJar->extractCookies($request, $response);
                    return $response;
                });
            };
        };
    }
    public static function httpErrors()
    {
        return function (callable $handler) {
            return function ($request, array $options) {
                static $handler = NULL;
                if(empty($options["http_errors"])) {
                    return $handler($request, $options);
                }
                return $handler($request, $options)->then(function (\Psr\Http\Message\ResponseInterface $response) {
                    static $request = NULL;
                    $code = $response->getStatusCode();
                    if($code < 400) {
                        return $response;
                    }
                    throw Exception\RequestException::create($request, $response);
                });
            };
        };
    }
    public static function history(&$container)
    {
        if(!is_array($container) && !$container instanceof \ArrayAccess) {
            throw new \InvalidArgumentException("history container must be an array or object implementing ArrayAccess");
        }
        return function (callable $handler) {
            static $container = NULL;
            return function ($request, array $options) {
                static $handler = NULL;
                static $container = NULL;
                return $handler($request, $options)->then(function ($value) {
                    static $request = NULL;
                    static $container = NULL;
                    static $options = NULL;
                    $container[] = ["request" => $request, "response" => $value, "error" => NULL, "options" => $options];
                    return $value;
                }, function ($reason) {
                    static $request = NULL;
                    static $container = NULL;
                    static $options = NULL;
                    $container[] = ["request" => $request, "response" => NULL, "error" => $reason, "options" => $options];
                    return Promise\rejection_for($reason);
                });
            };
        };
    }
    public static function tap(callable $before = NULL, callable $after = NULL)
    {
        return function (callable $handler) use($after) {
            static $before = NULL;
            return function ($request, array $options) {
                static $handler = NULL;
                static $before = NULL;
                static $after = NULL;
                if($before) {
                    $before($request, $options);
                }
                $response = $handler($request, $options);
                if($after) {
                    $after($request, $options, $response);
                }
                return $response;
            };
        };
    }
    public static function redirect()
    {
        return function (callable $handler) {
            return new RedirectMiddleware($handler);
        };
    }
    public static function retry(callable $decider, callable $delay = NULL)
    {
        return function (callable $handler) use($delay) {
            static $decider = NULL;
            return new RetryMiddleware($decider, $handler, $delay);
        };
    }
    public static function log(\Psr\Log\LoggerInterface $logger, MessageFormatter $formatter, $logLevel = "info")
    {
        return function (callable $handler) use($logLevel) {
            static $logger = NULL;
            static $formatter = NULL;
            return function ($request, array $options) {
                static $handler = NULL;
                static $logger = NULL;
                static $formatter = NULL;
                static $logLevel = NULL;
                return $handler($request, $options)->then(function ($response) {
                    static $logger = NULL;
                    static $request = NULL;
                    static $formatter = NULL;
                    static $logLevel = NULL;
                    $message = $formatter->format($request, $response);
                    $logger->log($logLevel, $message);
                    return $response;
                }, function ($reason) {
                    static $logger = NULL;
                    static $request = NULL;
                    static $formatter = NULL;
                    $response = $reason instanceof Exception\RequestException ? $reason->getResponse() : NULL;
                    $message = $formatter->format($request, $response, $reason);
                    $logger->notice($message);
                    return Promise\rejection_for($reason);
                });
            };
        };
    }
    public static function prepareBody()
    {
        return function (callable $handler) {
            return new PrepareBodyMiddleware($handler);
        };
    }
    public static function mapRequest(callable $fn)
    {
        return function (callable $handler) use($fn) {
            return function ($request, array $options) {
                static $handler = NULL;
                static $fn = NULL;
                return $handler($fn($request), $options);
            };
        };
    }
    public static function mapResponse(callable $fn)
    {
        return function (callable $handler) use($fn) {
            return function ($request, array $options) {
                static $handler = NULL;
                static $fn = NULL;
                return $handler($request, $options)->then($fn);
            };
        };
    }
}

?>