<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp\Handler;

class StreamHandler
{
    private $lastHeaders = [];
    public function __invoke(\Psr\Http\Message\RequestInterface $request, array $options)
    {
        if(isset($options["delay"])) {
            usleep($options["delay"] * 1000);
        }
        $startTime = isset($options["on_stats"]) ? _current_time() : NULL;
        try {
            $request = $request->withoutHeader("Expect");
            if(0 === $request->getBody()->getSize()) {
                $request = $request->withHeader("Content-Length", "0");
            }
            return $this->createResponse($request, $options, $this->createStream($request, $options), $startTime);
        } catch (\InvalidArgumentException $e) {
            throw $e;
        } catch (\Exception $e) {
            $message = $e->getMessage();
            if(strpos($message, "getaddrinfo") || strpos($message, "Connection refused") || strpos($message, "couldn't connect to host") || strpos($message, "connection attempt failed")) {
                $e = new \GuzzleHttp\Exception\ConnectException($e->getMessage(), $request, $e);
            }
            $e = \GuzzleHttp\Exception\RequestException::wrapException($request, $e);
            $this->invokeStats($options, $request, $startTime, NULL, $e);
            return GuzzleHttp\Promise\rejection_for($e);
        }
    }
    private function invokeStats(array $options, \Psr\Http\Message\RequestInterface $request, $startTime, \Psr\Http\Message\ResponseInterface $response = NULL, $error = NULL)
    {
        if(isset($options["on_stats"])) {
            $stats = new \GuzzleHttp\TransferStats($request, $response, _current_time() - $startTime, $error, []);
            call_user_func($options["on_stats"], $stats);
        }
    }
    private function createResponse(\Psr\Http\Message\RequestInterface $request, array $options, $stream, $startTime)
    {
        $hdrs = $this->lastHeaders;
        $this->lastHeaders = [];
        $parts = explode(" ", array_shift($hdrs), 3);
        list($ver) = explode("/", $parts[0]);
        $status = $parts[1];
        $reason = isset($parts[2]) ? $parts[2] : NULL;
        $headers = headers_from_lines($hdrs);
        list($stream, $headers) = $this->checkDecode($options, $headers, $stream);
        $stream = GuzzleHttp\Psr7\stream_for($stream);
        $sink = $stream;
        if(strcasecmp("HEAD", $request->getMethod())) {
            $sink = $this->createSink($stream, $options);
        }
        $response = new \GuzzleHttp\Psr7\Response($status, $headers, $sink, $ver, $reason);
        if(isset($options["on_headers"])) {
            try {
                $options["on_headers"]($response);
            } catch (\Exception $e) {
                $msg = "An error was encountered during the on_headers event";
                $ex = new \GuzzleHttp\Exception\RequestException($msg, $request, $response, $e);
                return GuzzleHttp\Promise\rejection_for($ex);
            }
        }
        if($sink !== $stream) {
            $this->drain($stream, $sink, $response->getHeaderLine("Content-Length"));
        }
        $this->invokeStats($options, $request, $startTime, $response, NULL);
        return new \GuzzleHttp\Promise\FulfilledPromise($response);
    }
    private function createSink(\Psr\Http\Message\StreamInterface $stream, array $options)
    {
        if(!empty($options["stream"])) {
            return $stream;
        }
        $sink = isset($options["sink"]) ? $options["sink"] : fopen("php://temp", "r+");
        return is_string($sink) ? new \GuzzleHttp\Psr7\LazyOpenStream($sink, "w+") : GuzzleHttp\Psr7\stream_for($sink);
    }
    private function checkDecode(array $options, array $headers, $stream)
    {
        if(!empty($options["decode_content"])) {
            $normalizedKeys = normalize_header_keys($headers);
            if(isset($normalizedKeys["content-encoding"])) {
                $encoding = $headers[$normalizedKeys["content-encoding"]];
                if($encoding[0] === "gzip" || $encoding[0] === "deflate") {
                    $stream = new \GuzzleHttp\Psr7\InflateStream(GuzzleHttp\Psr7\stream_for($stream));
                    $headers["x-encoded-content-encoding"] = $headers[$normalizedKeys["content-encoding"]];
                    unset($headers[$normalizedKeys["content-encoding"]]);
                    if(isset($normalizedKeys["content-length"])) {
                        $headers["x-encoded-content-length"] = $headers[$normalizedKeys["content-length"]];
                        $length = (int) $stream->getSize();
                        if($length === 0) {
                            unset($headers[$normalizedKeys["content-length"]]);
                        } else {
                            $headers[$normalizedKeys["content-length"]] = [$length];
                        }
                    }
                }
            }
        }
        return [$stream, $headers];
    }
    private function drain(\Psr\Http\Message\StreamInterface $source, \Psr\Http\Message\StreamInterface $sink, $contentLength)
    {
        copy_to_stream($source, $sink, 0 < strlen($contentLength) && 0 < (int) $contentLength ? (int) $contentLength : -1);
        $sink->seek(0);
        $source->close();
        return $sink;
    }
    private function createResource(callable $callback)
    {
        $errors = NULL;
        set_error_handler(function ($_, $msg, $file, $line) {
            static $errors = NULL;
            $errors[] = ["message" => $msg, "file" => $file, "line" => $line];
            return true;
        });
        $resource = $callback();
        restore_error_handler();
        if(!$resource) {
            $message = "Error creating resource: ";
            foreach ($errors as $err) {
                foreach ($err as $key => $value) {
                    $message .= "[" . $key . "] " . $value . PHP_EOL;
                }
            }
            throw new \RuntimeException(trim($message));
        } else {
            return $resource;
        }
    }
    private function createStream(\Psr\Http\Message\RequestInterface $request, array $options)
    {
        static $methods = NULL;
        if(!$methods) {
            $methods = array_flip(get_class_methods("Handler\\StreamHandler"));
        }
        if($request->getProtocolVersion() == "1.1" && !$request->hasHeader("Connection")) {
            $request = $request->withHeader("Connection", "close");
        }
        if(!isset($options["verify"])) {
            $options["verify"] = true;
        }
        $params = [];
        $context = $this->getDefaultContext($request);
        if(isset($options["on_headers"]) && !is_callable($options["on_headers"])) {
            throw new \InvalidArgumentException("on_headers must be callable");
        }
        if(!empty($options)) {
            foreach ($options as $key => $value) {
                $method = "add_" . $key;
                if(isset($methods[$method])) {
                    $this->{$method}($request, $context, $value, $params);
                }
            }
        }
        if(isset($options["stream_context"])) {
            if(!is_array($options["stream_context"])) {
                throw new \InvalidArgumentException("stream_context must be an array");
            }
            $context = array_replace_recursive($context, $options["stream_context"]);
        }
        if(isset($options["auth"]) && is_array($options["auth"]) && isset($options["auth"][2]) && "ntlm" == $options["auth"][2]) {
            throw new \InvalidArgumentException("Microsoft NTLM authentication only supported with curl handler");
        }
        $uri = $this->resolveHost($request, $options);
        $context = $this->createResource(function () {
            static $context = NULL;
            static $params = NULL;
            return stream_context_create($context, $params);
        });
        return $this->createResource(function () {
            static $uri = NULL;
            static $http_response_header = NULL;
            static $context = NULL;
            static $options = NULL;
            $resource = fopen((string) $uri, "r", NULL, $context);
            $this->lastHeaders = $http_response_header;
            if(isset($options["read_timeout"])) {
                $readTimeout = $options["read_timeout"];
                $sec = (int) $readTimeout;
                $usec = ($readTimeout - $sec) * 100000;
                stream_set_timeout($resource, $sec, $usec);
            }
            return $resource;
        });
    }
    private function resolveHost(\Psr\Http\Message\RequestInterface $request, array $options)
    {
        $uri = $request->getUri();
        if(isset($options["force_ip_resolve"]) && !filter_var($uri->getHost(), FILTER_VALIDATE_IP)) {
            if("v4" === $options["force_ip_resolve"]) {
                $records = dns_get_record($uri->getHost(), DNS_A);
                if(!isset($records[0]["ip"])) {
                    throw new \GuzzleHttp\Exception\ConnectException(sprintf("Could not resolve IPv4 address for host '%s'", $uri->getHost()), $request);
                }
                $uri = $uri->withHost($records[0]["ip"]);
            } elseif("v6" === $options["force_ip_resolve"]) {
                $records = dns_get_record($uri->getHost(), DNS_AAAA);
                if(!isset($records[0]["ipv6"])) {
                    throw new \GuzzleHttp\Exception\ConnectException(sprintf("Could not resolve IPv6 address for host '%s'", $uri->getHost()), $request);
                }
                $uri = $uri->withHost("[" . $records[0]["ipv6"] . "]");
            }
        }
        return $uri;
    }
    private function getDefaultContext(\Psr\Http\Message\RequestInterface $request)
    {
        $headers = "";
        foreach ($request->getHeaders() as $name => $value) {
            foreach ($value as $val) {
                $headers .= $name . ": " . $val . "\r\n";
            }
        }
        $context = ["http" => ["method" => $request->getMethod(), "header" => $headers, "protocol_version" => $request->getProtocolVersion(), "ignore_errors" => true, "follow_location" => 0]];
        $body = (string) $request->getBody();
        if(!empty($body)) {
            $context["http"]["content"] = $body;
            if(!$request->hasHeader("Content-Type")) {
                $context["http"]["header"] .= "Content-Type:\r\n";
            }
        }
        $context["http"]["header"] = rtrim($context["http"]["header"]);
        return $context;
    }
    private function add_proxy(\Psr\Http\Message\RequestInterface $request, &$options, $value, &$params)
    {
        if(!is_array($value)) {
            $options["http"]["proxy"] = $value;
        } else {
            $scheme = $request->getUri()->getScheme();
            if(isset($value[$scheme]) && (!isset($value["no"]) || !GuzzleHttp\is_host_in_noproxy($request->getUri()->getHost(), $value["no"]))) {
                $options["http"]["proxy"] = $value[$scheme];
            }
        }
    }
    private function add_timeout(\Psr\Http\Message\RequestInterface $request, &$options, $value, &$params)
    {
        if(0 < $value) {
            $options["http"]["timeout"] = $value;
        }
    }
    private function add_verify(\Psr\Http\Message\RequestInterface $request, &$options, $value, &$params)
    {
        if($value === true) {
            if(PHP_VERSION_ID < 50600) {
                $options["ssl"]["cafile"] = default_ca_bundle();
            }
        } elseif(is_string($value)) {
            $options["ssl"]["cafile"] = $value;
            if(!file_exists($value)) {
                throw new \RuntimeException("SSL CA bundle not found: " . $value);
            }
        } else {
            if($value === false) {
                $options["ssl"]["verify_peer"] = false;
                $options["ssl"]["verify_peer_name"] = false;
                return NULL;
            }
            throw new \InvalidArgumentException("Invalid verify request option");
        }
        $options["ssl"]["verify_peer"] = true;
        $options["ssl"]["verify_peer_name"] = true;
        $options["ssl"]["allow_self_signed"] = false;
    }
    private function add_cert(\Psr\Http\Message\RequestInterface $request, &$options, $value, &$params)
    {
        if(is_array($value)) {
            list($value, $options["ssl"]["passphrase"]) = $value;
        }
        if(!file_exists($value)) {
            throw new \RuntimeException("SSL certificate not found: " . $value);
        }
        $options["ssl"]["local_cert"] = $value;
    }
    private function add_progress(\Psr\Http\Message\RequestInterface $request, &$options, $value, &$params)
    {
        $this->addNotification($params, function ($code, $a, $b, $c, $transferred, $total) {
            static $value = NULL;
            if($code == STREAM_NOTIFY_PROGRESS) {
                $value($total, $transferred, NULL, NULL);
            }
        });
    }
    private function add_debug(\Psr\Http\Message\RequestInterface $request, &$options, $value, &$params)
    {
        if($value === false) {
            return NULL;
        }
        static $map = NULL;
        static $args = ["severity", "message", "message_code", "bytes_transferred", "bytes_max"];
        $value = GuzzleHttp\debug_resource($value);
        $ident = $request->getMethod() . " " . $request->getUri()->withFragment("");
        $this->addNotification($params, function () {
            static $ident = NULL;
            static $value = NULL;
            static $map = NULL;
            static $args = NULL;
            $passed = func_get_args();
            $code = array_shift($passed);
            fprintf($value, "<%s> [%s] ", $ident, $map[$code]);
            foreach (array_filter($passed) as $i => $v) {
                fwrite($value, $args[$i] . ": \"" . $v . "\" ");
            }
            fwrite($value, "\n");
        });
    }
    private function addNotification(array &$params, callable $notify)
    {
        if(!isset($params["notification"])) {
            $params["notification"] = $notify;
        } else {
            $params["notification"] = $this->callArray([$params["notification"], $notify]);
        }
    }
    private function callArray(array $functions)
    {
        return function () {
            static $functions = NULL;
            $args = func_get_args();
            foreach ($functions as $fn) {
                call_user_func_array($fn, $args);
            }
        };
    }
}

?>