<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp\Handler;

class MockHandler implements \Countable
{
    private $queue = [];
    private $lastRequest;
    private $lastOptions;
    private $onFulfilled;
    private $onRejected;
    public static function createWithMiddleware(array $queue = NULL, callable $onFulfilled = NULL, callable $onRejected = NULL)
    {
        return \GuzzleHttp\HandlerStack::create(new self($queue, $onFulfilled, $onRejected));
    }
    public function __construct(array $queue = NULL, callable $onFulfilled = NULL, callable $onRejected = NULL)
    {
        $this->onFulfilled = $onFulfilled;
        $this->onRejected = $onRejected;
        if($queue) {
            call_user_func_array([$this, "append"], $queue);
        }
    }
    public function __invoke(\Psr\Http\Message\RequestInterface $request, array $options)
    {
        if(!$this->queue) {
            throw new \OutOfBoundsException("Mock queue is empty");
        }
        if(isset($options["delay"])) {
            usleep($options["delay"] * 1000);
        }
        $this->lastRequest = $request;
        $this->lastOptions = $options;
        $response = array_shift($this->queue);
        if(isset($options["on_headers"])) {
            if(!is_callable($options["on_headers"])) {
                throw new \InvalidArgumentException("on_headers must be callable");
            }
            try {
                $options["on_headers"]($response);
            } catch (\Exception $e) {
                $msg = "An error was encountered during the on_headers event";
                $response = new \GuzzleHttp\Exception\RequestException($msg, $request, $response, $e);
            }
        }
        if(is_callable($response)) {
            $response = call_user_func($response, $request, $options);
        }
        $response = $response instanceof \Exception ? GuzzleHttp\Promise\rejection_for($response) : GuzzleHttp\Promise\promise_for($response);
        return $response->then(function ($value) {
            static $request = NULL;
            static $options = NULL;
            $this->invokeStats($request, $options, $value);
            if($this->onFulfilled) {
                call_user_func($this->onFulfilled, $value);
            }
            if(isset($options["sink"])) {
                $contents = (string) $value->getBody();
                $sink = $options["sink"];
                if(is_resource($sink)) {
                    fwrite($sink, $contents);
                } elseif(is_string($sink)) {
                    file_put_contents($sink, $contents);
                } elseif($sink instanceof \Psr\Http\Message\StreamInterface) {
                    $sink->write($contents);
                }
            }
            return $value;
        }, function ($reason) {
            static $request = NULL;
            static $options = NULL;
            $this->invokeStats($request, $options, NULL, $reason);
            if($this->onRejected) {
                call_user_func($this->onRejected, $reason);
            }
            return GuzzleHttp\Promise\rejection_for($reason);
        });
    }
    public function append()
    {
        foreach (func_get_args() as $value) {
            if($value instanceof \Psr\Http\Message\ResponseInterface || $value instanceof \Exception || $value instanceof \GuzzleHttp\Promise\PromiseInterface || is_callable($value)) {
                $this->queue[] = $value;
            } else {
                throw new \InvalidArgumentException("Expected a response or exception. Found " . GuzzleHttp\describe_type($value));
            }
        }
    }
    public function getLastRequest()
    {
        return $this->lastRequest;
    }
    public function getLastOptions()
    {
        return $this->lastOptions;
    }
    public function count()
    {
        return count($this->queue);
    }
    private function invokeStats(\Psr\Http\Message\RequestInterface $request, array $options, \Psr\Http\Message\ResponseInterface $response = NULL, $reason = NULL)
    {
        if(isset($options["on_stats"])) {
            $transferTime = isset($options["transfer_time"]) ? $options["transfer_time"] : 0;
            $stats = new \GuzzleHttp\TransferStats($request, $response, $transferTime, $reason);
            call_user_func($options["on_stats"], $stats);
        }
    }
}

?>