<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp\Handler;

class CurlMultiHandler
{
    private $factory;
    private $selectTimeout;
    private $active;
    private $handles = [];
    private $delays = [];
    public function __construct(array $options = [])
    {
        $this->factory = isset($options["handle_factory"]) ? $options["handle_factory"] : new CurlFactory(50);
        if(isset($options["select_timeout"])) {
            $this->selectTimeout = $options["select_timeout"];
        } elseif($selectTimeout = getenv("GUZZLE_CURL_SELECT_TIMEOUT")) {
            $this->selectTimeout = $selectTimeout;
        } else {
            $this->selectTimeout = 1;
        }
    }
    public function __get($name)
    {
        if($name === "_mh") {
            return $this->_mh = curl_multi_init();
        }
        throw new \BadMethodCallException();
    }
    public function __destruct()
    {
        if(isset($this->_mh)) {
            curl_multi_close($this->_mh);
            unset($this->_mh);
        }
    }
    public function __invoke(\Psr\Http\Message\RequestInterface $request, array $options)
    {
        $easy = $this->factory->create($request, $options);
        $id = (int) $easy->handle;
        $promise = new \GuzzleHttp\Promise\Promise([$this, "execute"], function () {
            static $id = NULL;
            return $this->cancel($id);
        });
        $this->addRequest(["easy" => $easy, "deferred" => $promise]);
        return $promise;
    }
    public function tick()
    {
        if($this->delays) {
            $currentTime = _current_time();
            foreach ($this->delays as $id => $delay) {
                if($delay <= $currentTime) {
                    unset($this->delays[$id]);
                    curl_multi_add_handle($this->_mh, $this->handles[$id]["easy"]->handle);
                }
            }
        }
        GuzzleHttp\Promise\queue()->run();
        if($this->active && curl_multi_select($this->_mh, $this->selectTimeout) === -1) {
            usleep(250);
        }
        do {
        } while (curl_multi_exec($this->_mh, $this->active) !== CURLM_CALL_MULTI_PERFORM);
        $this->processMessages();
    }
    public function execute()
    {
        $queue = GuzzleHttp\Promise\queue();
        while ($this->handles || !$queue->isEmpty()) {
            if(!$this->active && $this->delays) {
                usleep($this->timeToNext());
            }
            $this->tick();
        }
    }
    private function addRequest(array $entry)
    {
        $easy = $entry["easy"];
        $id = (int) $easy->handle;
        $this->handles[$id] = $entry;
        if(empty($easy->options["delay"])) {
            curl_multi_add_handle($this->_mh, $easy->handle);
        } else {
            $this->delays[$id] = _current_time() + $easy->options["delay"] / 1000;
        }
    }
    private function cancel($id)
    {
        if(!isset($this->handles[$id])) {
            return false;
        }
        $handle = $this->handles[$id]["easy"]->handle;
        unset($this->delays[$id]);
        unset($this->handles[$id]);
        curl_multi_remove_handle($this->_mh, $handle);
        curl_close($handle);
        return true;
    }
    private function processMessages()
    {
        while ($done = curl_multi_info_read($this->_mh)) {
            $id = (int) $done["handle"];
            curl_multi_remove_handle($this->_mh, $done["handle"]);
            if(!isset($this->handles[$id])) {
            } else {
                $entry = $this->handles[$id];
                unset($this->handles[$id]);
                unset($this->delays[$id]);
                $entry["easy"]->errno = $done["result"];
                $entry["deferred"]->resolve(CurlFactory::finish($this, $entry["easy"], $this->factory));
            }
        }
    }
    private function timeToNext()
    {
        $currentTime = _current_time();
        $nextTime = PHP_INT_MAX;
        foreach ($this->delays as $time) {
            if($time < $nextTime) {
                $nextTime = $time;
            }
        }
        return max(0, $nextTime - $currentTime) * 1000000;
    }
}

?>