<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp\Handler;

class CurlFactory implements CurlFactoryInterface
{
    private $handles = [];
    private $maxHandles;
    const CURL_VERSION_STR = "curl_version";
    const LOW_CURL_VERSION_NUMBER = "7.21.2";
    public function __construct($maxHandles)
    {
        $this->maxHandles = $maxHandles;
    }
    public function create(\Psr\Http\Message\RequestInterface $request, array $options)
    {
        if(isset($options["curl"]["body_as_string"])) {
            $options["_body_as_string"] = $options["curl"]["body_as_string"];
            unset($options["curl"]["body_as_string"]);
        }
        $easy = new EasyHandle();
        $easy->request = $request;
        $easy->options = $options;
        $conf = $this->getDefaultConf($easy);
        $this->applyMethod($easy, $conf);
        $this->applyHandlerOptions($easy, $conf);
        $this->applyHeaders($easy, $conf);
        unset($conf["_headers"]);
        if(isset($options["curl"])) {
            $conf = array_replace($conf, $options["curl"]);
        }
        $conf[CURLOPT_HEADERFUNCTION] = $this->createHeaderFn($easy);
        $easy->handle = $this->handles ? array_pop($this->handles) : curl_init();
        curl_setopt_array($easy->handle, $conf);
        return $easy;
    }
    public function release(EasyHandle $easy)
    {
        $resource = $easy->handle;
        unset($easy->handle);
        if($this->maxHandles <= count($this->handles)) {
            curl_close($resource);
        } else {
            curl_setopt($resource, CURLOPT_HEADERFUNCTION, NULL);
            curl_setopt($resource, CURLOPT_READFUNCTION, NULL);
            curl_setopt($resource, CURLOPT_WRITEFUNCTION, NULL);
            curl_setopt($resource, CURLOPT_PROGRESSFUNCTION, NULL);
            curl_reset($resource);
            $this->handles[] = $resource;
        }
    }
    public static function finish(callable $handler, EasyHandle $easy, CurlFactoryInterface $factory)
    {
        if(isset($easy->options["on_stats"])) {
            self::invokeStats($easy);
        }
        if(!$easy->response || $easy->errno) {
            return self::finishError($handler, $easy, $factory);
        }
        $factory->release($easy);
        $body = $easy->response->getBody();
        if($body->isSeekable()) {
            $body->rewind();
        }
        return new \GuzzleHttp\Promise\FulfilledPromise($easy->response);
    }
    private static function invokeStats(EasyHandle $easy)
    {
        $curlStats = curl_getinfo($easy->handle);
        $curlStats["appconnect_time"] = curl_getinfo($easy->handle, CURLINFO_APPCONNECT_TIME);
        $stats = new \GuzzleHttp\TransferStats($easy->request, $easy->response, $curlStats["total_time"], $easy->errno, $curlStats);
        call_user_func($easy->options["on_stats"], $stats);
    }
    private static function finishError(callable $handler, EasyHandle $easy, CurlFactoryInterface $factory)
    {
        $ctx = ["errno" => $easy->errno, "error" => curl_error($easy->handle), "appconnect_time" => curl_getinfo($easy->handle, CURLINFO_APPCONNECT_TIME)] + curl_getinfo($easy->handle);
        $ctx[self::CURL_VERSION_STR] = curl_version()["version"];
        $factory->release($easy);
        if(empty($easy->options["_err_message"]) && (!$easy->errno || $easy->errno == 65)) {
            return self::retryFailedRewind($handler, $easy, $ctx);
        }
        return self::createRejection($easy, $ctx);
    }
    private static function createRejection(EasyHandle $easy, array $ctx)
    {
        static $connectionErrors = NULL;
        if($easy->onHeadersException) {
            return GuzzleHttp\Promise\rejection_for(new \GuzzleHttp\Exception\RequestException("An error was encountered during the on_headers event", $easy->request, $easy->response, $easy->onHeadersException, $ctx));
        }
        if(version_compare($ctx[self::CURL_VERSION_STR], self::LOW_CURL_VERSION_NUMBER)) {
            $message = sprintf("cURL error %s: %s (%s)", $ctx["errno"], $ctx["error"], "see https://curl.haxx.se/libcurl/c/libcurl-errors.html");
        } else {
            $message = sprintf("cURL error %s: %s (%s) for %s", $ctx["errno"], $ctx["error"], "see https://curl.haxx.se/libcurl/c/libcurl-errors.html", $easy->request->getUri());
        }
        $error = isset($connectionErrors[$easy->errno]) ? new \GuzzleHttp\Exception\ConnectException($message, $easy->request, NULL, $ctx) : new \GuzzleHttp\Exception\RequestException($message, $easy->request, $easy->response, NULL, $ctx);
        return GuzzleHttp\Promise\rejection_for($error);
    }
    private function getDefaultConf(EasyHandle $easy)
    {
        $conf = ["_headers" => $easy->request->getHeaders(), CURLOPT_CUSTOMREQUEST => $easy->request->getMethod(), CURLOPT_URL => (string) $easy->request->getUri()->withFragment(""), CURLOPT_RETURNTRANSFER => false, CURLOPT_HEADER => false, CURLOPT_CONNECTTIMEOUT => 150];
        if(defined("CURLOPT_PROTOCOLS")) {
            $conf[CURLOPT_PROTOCOLS] = CURLPROTO_HTTP | CURLPROTO_HTTPS;
        }
        $version = $easy->request->getProtocolVersion();
        if($version == 0) {
            $conf[CURLOPT_HTTP_VERSION] = CURL_HTTP_VERSION_1_1;
        } elseif($version == 0) {
            $conf[CURLOPT_HTTP_VERSION] = CURL_HTTP_VERSION_2_0;
        } else {
            $conf[CURLOPT_HTTP_VERSION] = CURL_HTTP_VERSION_1_0;
        }
        return $conf;
    }
    private function applyMethod(EasyHandle $easy, array &$conf)
    {
        $body = $easy->request->getBody();
        $size = $body->getSize();
        if($size === NULL || 0 < $size) {
            $this->applyBody($easy->request, $easy->options, $conf);
        } else {
            $method = $easy->request->getMethod();
            if($method === "PUT" || $method === "POST") {
                if(!$easy->request->hasHeader("Content-Length")) {
                    $conf[CURLOPT_HTTPHEADER][] = "Content-Length: 0";
                }
            } elseif($method === "HEAD") {
                $conf[CURLOPT_NOBODY] = true;
                unset($conf[CURLOPT_WRITEFUNCTION]);
                unset($conf[CURLOPT_READFUNCTION]);
                unset($conf[CURLOPT_FILE]);
                unset($conf[CURLOPT_INFILE]);
            }
        }
    }
    private function applyBody(\Psr\Http\Message\RequestInterface $request, array $options, array &$conf)
    {
        $size = $request->hasHeader("Content-Length") ? (int) $request->getHeaderLine("Content-Length") : NULL;
        if($size !== NULL && $size < 1000000 || !empty($options["_body_as_string"])) {
            $conf[CURLOPT_POSTFIELDS] = (string) $request->getBody();
            $this->removeHeader("Content-Length", $conf);
            $this->removeHeader("Transfer-Encoding", $conf);
        } else {
            $conf[CURLOPT_UPLOAD] = true;
            if($size !== NULL) {
                $conf[CURLOPT_INFILESIZE] = $size;
                $this->removeHeader("Content-Length", $conf);
            }
            $body = $request->getBody();
            if($body->isSeekable()) {
                $body->rewind();
            }
            $conf[CURLOPT_READFUNCTION] = function ($ch, $fd, $length) {
                static $body = NULL;
                return $body->read($length);
            };
        }
        if(!$request->hasHeader("Expect")) {
            $conf[CURLOPT_HTTPHEADER][] = "Expect:";
        }
        if(!$request->hasHeader("Content-Type")) {
            $conf[CURLOPT_HTTPHEADER][] = "Content-Type:";
        }
    }
    private function applyHeaders(EasyHandle $easy, array &$conf)
    {
        foreach ($conf["_headers"] as $name => $values) {
            foreach ($values as $value) {
                $value = (string) $value;
                if($value === "") {
                    $conf[CURLOPT_HTTPHEADER][] = $name . ";";
                } else {
                    $conf[CURLOPT_HTTPHEADER][] = $name . ": " . $value;
                }
            }
        }
        if(!$easy->request->hasHeader("Accept")) {
            $conf[CURLOPT_HTTPHEADER][] = "Accept:";
        }
    }
    private function removeHeader($name, array &$options)
    {
        foreach (array_keys($options["_headers"]) as $key) {
            if(!strcasecmp($key, $name)) {
                unset($options["_headers"][$key]);
                return NULL;
            }
        }
    }
    private function applyHandlerOptions(EasyHandle $easy, array &$conf)
    {
        $options = $easy->options;
        if(isset($options["verify"])) {
            if($options["verify"] === false) {
                unset($conf[CURLOPT_CAINFO]);
                $conf[CURLOPT_SSL_VERIFYHOST] = 0;
                $conf[CURLOPT_SSL_VERIFYPEER] = false;
            } else {
                $conf[CURLOPT_SSL_VERIFYHOST] = 2;
                $conf[CURLOPT_SSL_VERIFYPEER] = true;
                if(is_string($options["verify"])) {
                    if(!file_exists($options["verify"])) {
                        throw new \InvalidArgumentException("SSL CA bundle not found: " . $options["verify"]);
                    }
                    if(is_dir($options["verify"]) || is_link($options["verify"]) && is_dir(readlink($options["verify"]))) {
                        $conf[CURLOPT_CAPATH] = $options["verify"];
                    } else {
                        $conf[CURLOPT_CAINFO] = $options["verify"];
                    }
                }
            }
        }
        if(!empty($options["decode_content"])) {
            $accept = $easy->request->getHeaderLine("Accept-Encoding");
            if($accept) {
                $conf[CURLOPT_ENCODING] = $accept;
            } else {
                $conf[CURLOPT_ENCODING] = "";
                $conf[CURLOPT_HTTPHEADER][] = "Accept-Encoding:";
            }
        }
        if(isset($options["sink"])) {
            $sink = $options["sink"];
            if(!is_string($sink)) {
                $sink = GuzzleHttp\Psr7\stream_for($sink);
            } else {
                if(!is_dir(dirname($sink))) {
                    throw new \RuntimeException(sprintf("Directory %s does not exist for sink value of %s", dirname($sink), $sink));
                }
                $sink = new \GuzzleHttp\Psr7\LazyOpenStream($sink, "w+");
            }
            $easy->sink = $sink;
            $conf[CURLOPT_WRITEFUNCTION] = function ($ch, $write) {
                static $sink = NULL;
                return $sink->write($write);
            };
        } else {
            $conf[CURLOPT_FILE] = fopen("php://temp", "w+");
            $easy->sink = GuzzleHttp\Psr7\stream_for($conf[CURLOPT_FILE]);
        }
        $timeoutRequiresNoSignal = false;
        if(isset($options["timeout"])) {
            $timeoutRequiresNoSignal |= $options["timeout"] < 1;
            $conf[CURLOPT_TIMEOUT_MS] = $options["timeout"] * 1000;
        }
        if(isset($options["force_ip_resolve"])) {
            if("v4" === $options["force_ip_resolve"]) {
                $conf[CURLOPT_IPRESOLVE] = CURL_IPRESOLVE_V4;
            } elseif("v6" === $options["force_ip_resolve"]) {
                $conf[CURLOPT_IPRESOLVE] = CURL_IPRESOLVE_V6;
            }
        }
        if(isset($options["connect_timeout"])) {
            $timeoutRequiresNoSignal |= $options["connect_timeout"] < 1;
            $conf[CURLOPT_CONNECTTIMEOUT_MS] = $options["connect_timeout"] * 1000;
        }
        if($timeoutRequiresNoSignal && strtoupper(substr(PHP_OS, 0, 3)) !== "WIN") {
            $conf[CURLOPT_NOSIGNAL] = true;
        }
        if(isset($options["proxy"])) {
            if(!is_array($options["proxy"])) {
                $conf[CURLOPT_PROXY] = $options["proxy"];
            } else {
                $scheme = $easy->request->getUri()->getScheme();
                if(isset($options["proxy"][$scheme])) {
                    $host = $easy->request->getUri()->getHost();
                    if(!isset($options["proxy"]["no"]) || !GuzzleHttp\is_host_in_noproxy($host, $options["proxy"]["no"])) {
                        $conf[CURLOPT_PROXY] = $options["proxy"][$scheme];
                    }
                }
            }
        }
        if(isset($options["cert"])) {
            $cert = $options["cert"];
            if(is_array($cert)) {
                list($cert, $conf[CURLOPT_SSLCERTPASSWD]) = $cert;
            }
            if(!file_exists($cert)) {
                throw new \InvalidArgumentException("SSL certificate not found: " . $cert);
            }
            $conf[CURLOPT_SSLCERT] = $cert;
        }
        if(isset($options["ssl_key"])) {
            $sslKey = $options["ssl_key"];
            if(is_array($sslKey)) {
                list($sslKey, $conf[CURLOPT_SSLKEYPASSWD]) = $sslKey;
            }
            if(!file_exists($sslKey)) {
                throw new \InvalidArgumentException("SSL private key not found: " . $sslKey);
            }
            $conf[CURLOPT_SSLKEY] = $sslKey;
        }
        if(isset($options["progress"])) {
            $progress = $options["progress"];
            if(!is_callable($progress)) {
                throw new \InvalidArgumentException("progress client option must be callable");
            }
            $conf[CURLOPT_NOPROGRESS] = false;
            $conf[CURLOPT_PROGRESSFUNCTION] = function () {
                static $progress = NULL;
                $args = func_get_args();
                if(is_resource($args[0])) {
                    array_shift($args);
                }
                call_user_func_array($progress, $args);
            };
        }
        if(!empty($options["debug"])) {
            $conf[CURLOPT_STDERR] = GuzzleHttp\debug_resource($options["debug"]);
            $conf[CURLOPT_VERBOSE] = true;
        }
    }
    private static function retryFailedRewind(callable $handler, EasyHandle $easy, array $ctx)
    {
        try {
            $body = $easy->request->getBody();
            if(0 < $body->tell()) {
                $body->rewind();
            }
        } catch (\RuntimeException $e) {
            $ctx["error"] = "The connection unexpectedly failed without providing an error. The request would have been retried, but attempting to rewind the request body failed. Exception: " . $e;
            return self::createRejection($easy, $ctx);
        }
        if(!isset($easy->options["_curl_retries"])) {
            $easy->options["_curl_retries"] = 1;
        } else {
            if($easy->options["_curl_retries"] == 2) {
                $ctx["error"] = "The cURL request was retried 3 times and did not succeed. The most likely reason for the failure is that cURL was unable to rewind the body of the request and subsequent retries resulted in the same error. Turn on the debug option to see what went wrong. See https://bugs.php.net/bug.php?id=47204 for more information.";
                return self::createRejection($easy, $ctx);
            }
            $easy->options["_curl_retries"]++;
        }
        return $handler($easy->request, $easy->options);
    }
    private function createHeaderFn(EasyHandle $easy)
    {
        if(isset($easy->options["on_headers"])) {
            $onHeaders = $easy->options["on_headers"];
            if(!is_callable($onHeaders)) {
                throw new \InvalidArgumentException("on_headers must be callable");
            }
        } else {
            $onHeaders = NULL;
        }
        return function ($ch, $h) {
            static $onHeaders = NULL;
            static $easy = NULL;
            static $startingResponse = NULL;
            $value = trim($h);
            if($value === "") {
                $startingResponse = true;
                $easy->createResponse();
                if($onHeaders !== NULL) {
                    try {
                        $onHeaders($easy->response);
                    } catch (\Exception $e) {
                        $easy->onHeadersException = $e;
                        return -1;
                    }
                }
            } elseif($startingResponse) {
                $startingResponse = false;
                $easy->headers = [$value];
            } else {
                $easy->headers[] = $value;
            }
            return strlen($h);
        };
    }
}

?>