<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp\Exception;

class RequestException extends TransferException
{
    private $request;
    private $response;
    private $handlerContext;
    public function __construct($message, \Psr\Http\Message\RequestInterface $request, \Psr\Http\Message\ResponseInterface $response = NULL, \Exception $previous = NULL, array $handlerContext = [])
    {
        $code = $response && !$response instanceof \GuzzleHttp\Promise\PromiseInterface ? $response->getStatusCode() : 0;
        parent::__construct($message, $code, $previous);
        $this->request = $request;
        $this->response = $response;
        $this->handlerContext = $handlerContext;
    }
    public static function wrapException(\Psr\Http\Message\RequestInterface $request, \Exception $e)
    {
        return $e instanceof RequestException ? $e : new RequestException($e->getMessage(), $request, NULL, $e);
    }
    public static function create(\Psr\Http\Message\RequestInterface $request, \Psr\Http\Message\ResponseInterface $response = NULL, \Exception $previous = NULL, array $ctx = [])
    {
        if(!$response) {
            return new self("Error completing request", $request, NULL, $previous, $ctx);
        }
        $level = (int) floor($response->getStatusCode() / 100);
        if($level === 4) {
            $label = "Client error";
            $className = "Exception\\ClientException";
        } elseif($level === 5) {
            $label = "Server error";
            $className = "Exception\\ServerException";
        } else {
            $label = "Unsuccessful request";
            $className = "Exception\\RequestException";
        }
        $uri = $request->getUri();
        $uri = static::obfuscateUri($uri);
        $message = sprintf("%s: `%s %s` resulted in a `%s %s` response", $label, $request->getMethod(), $uri, $response->getStatusCode(), $response->getReasonPhrase());
        $summary = static::getResponseBodySummary($response);
        if($summary !== NULL) {
            $message .= ":\n" . $summary . "\n";
        }
        return new $className($message, $request, $response, $previous, $ctx);
    }
    public static function getResponseBodySummary(\Psr\Http\Message\ResponseInterface $response)
    {
        $body = $response->getBody();
        if(!$body->isSeekable() || !$body->isReadable()) {
            return NULL;
        }
        $size = $body->getSize();
        if($size === 0) {
            return NULL;
        }
        $summary = $body->read(120);
        $body->rewind();
        if(120 < $size) {
            $summary .= " (truncated...)";
        }
        if(preg_match("/[^\\pL\\pM\\pN\\pP\\pS\\pZ\\n\\r\\t]/", $summary)) {
            return NULL;
        }
        return $summary;
    }
    private static function obfuscateUri($uri)
    {
        $userInfo = $uri->getUserInfo();
        if(false !== ($pos = strpos($userInfo, ":"))) {
            return $uri->withUserInfo(substr($userInfo, 0, $pos), "***");
        }
        return $uri;
    }
    public function getRequest()
    {
        return $this->request;
    }
    public function getResponse()
    {
        return $this->response;
    }
    public function hasResponse()
    {
        return $this->response !== NULL;
    }
    public function getHandlerContext()
    {
        return $this->handlerContext;
    }
}

?>