<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp\Cookie;

class SessionCookieJar extends CookieJar
{
    private $sessionKey;
    private $storeSessionCookies;
    public function __construct($sessionKey, $storeSessionCookies = false)
    {
        parent::__construct();
        $this->sessionKey = $sessionKey;
        $this->storeSessionCookies = $storeSessionCookies;
        $this->load();
    }
    public function __destruct()
    {
        $this->save();
    }
    public function save()
    {
        $json = [];
        foreach ($this as $cookie) {
            if(CookieJar::shouldPersist($cookie, $this->storeSessionCookies)) {
                $json[] = $cookie->toArray();
            }
        }
        $_SESSION[$this->sessionKey] = json_encode($json);
    }
    protected function load()
    {
        if(!isset($_SESSION[$this->sessionKey])) {
            return NULL;
        }
        $data = json_decode($_SESSION[$this->sessionKey], true);
        if(is_array($data)) {
            foreach ($data as $cookie) {
                $this->setCookie(new SetCookie($cookie));
            }
        } elseif(strlen($data)) {
            throw new \RuntimeException("Invalid cookie data");
        }
    }
}

?>