<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace CoinbaseCommerce\Tests\Resources;

class EventTest extends \CoinbaseCommerce\Tests\BaseTest
{
    public function setUp()
    {
        parent::setUp();
        \CoinbaseCommerce\Resources\Event::setClient($this->apiClient);
    }
    public function testRefreshMethod()
    {
        $this->appendRequest(200, $this->parseJsonFile("event.json"));
        $id = "488fcbd5-eb82-42dc-8a2b-10fdf70e0bfe";
        $eventObj = new \CoinbaseCommerce\Resources\Event();
        $eventObj->id = $id;
        $eventObj->refresh();
        $this->assertRequested("GET", "/events/" . $id, "");
        $this->assertEquals($eventObj->type, "charge:failed");
    }
    public function testRetrieveMethod()
    {
        $this->appendRequest(200, $this->parseJsonFile("event.json"));
        $id = "488fcbd5-eb82-42dc-8a2b-10fdf70e0bfe";
        $eventObj = \CoinbaseCommerce\Resources\Event::retrieve($id);
        $this->assertRequested("GET", "/events/" . $id, "");
        $this->assertEquals($eventObj->type, "charge:failed");
        $this->assertInstanceOf(\CoinbaseCommerce\Resources\Charge::getClassName(), $eventObj->data);
    }
    public function testListMethod()
    {
        $eventResponse = $this->parseJsonFile("eventList.json");
        $this->appendRequest(200, $eventResponse);
        $this->logger->expects($this->once())->method("warning")->with(implode(",", $eventResponse["warnings"]));
        $eventList = \CoinbaseCommerce\Resources\Event::getList(["limit" => 2, "order" => "asc"]);
        $this->assertRequested("GET", "/events", "limit=2&order=asc");
        $this->assertInstanceOf(\CoinbaseCommerce\ApiResourceList::getClassName(), $eventList);
        $this->assertEquals("charge:failed", $eventList[0]["type"]);
        $this->assertEquals("Satoshi Nakamoto", $eventList[0]["data"]["metadata"]["customer_name"]);
    }
}

?>