<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace CoinbaseCommerce\Tests\Resources;

class ChargeTest extends \CoinbaseCommerce\Tests\BaseTest
{
    public function setUp()
    {
        parent::setUp();
        \CoinbaseCommerce\Resources\Charge::setClient($this->apiClient);
    }
    public function testInsertMethod()
    {
        $this->appendRequest(200, $this->parseJsonFile("charge.json"));
        $data = ["name" => "My test name", "description" => "Mastering the Transition to the Information Age"];
        $chargeObj = new \CoinbaseCommerce\Resources\Charge($data);
        $chargeObj->insert();
        $this->assertRequested("POST", "/charges", "");
        $this->assertEquals("7C7V5ECK", $chargeObj->code);
    }
    public function testSaveMethod()
    {
        $this->appendRequest(200, $this->parseJsonFile("charge.json"));
        $chargeObj = new \CoinbaseCommerce\Resources\Charge(["name" => "My test name", "description" => "Mastering the Transition to the Information Age"]);
        $chargeObj->save();
        $this->assertRequested("POST", "/charges", "");
        $this->assertInstanceOf(\CoinbaseCommerce\Resources\Charge::getClassName(), $chargeObj);
        $this->assertEquals("7C7V5ECK", $chargeObj->code);
    }
    public function testSaveMethodWithId()
    {
        $this->appendRequest(200, $this->parseJsonFile("charge.json"));
        $chargeObj = new \CoinbaseCommerce\Resources\Charge(["id" => "488fcbd5-eb82-42dc-8a2b-10fdf70e0bfe", "name" => "My test name", "description" => "Mastering the Transition to the Information Age"]);
        $chargeObj->save();
    }
    public function testCreateMethod()
    {
        $this->appendRequest(200, $this->parseJsonFile("charge.json"));
        $chargeObj = \CoinbaseCommerce\Resources\Charge::create(["name" => "My test name", "description" => "Mastering the Transition to the Information Age"]);
        $this->assertRequested("POST", "/charges", "");
        $this->assertInstanceOf(\CoinbaseCommerce\Resources\Charge::getClassName(), $chargeObj);
        $this->assertEquals("7C7V5ECK", $chargeObj->code);
    }
    public function testRefreshMethod()
    {
        $this->appendRequest(200, $this->parseJsonFile("charge.json"));
        $id = "488fcbd5-eb82-42dc-8a2b-10fdf70e0bfe";
        $chargeObj = new \CoinbaseCommerce\Resources\Charge();
        $chargeObj->id = $id;
        $chargeObj->refresh();
        $this->assertRequested("GET", "/charges/" . $id, "");
        $this->assertInstanceOf(\CoinbaseCommerce\Resources\Charge::getClassName(), $chargeObj);
        $this->assertEquals("7C7V5ECK", $chargeObj->code);
    }
    public function testRetrieveMethod()
    {
        $this->appendRequest(200, $this->parseJsonFile("charge.json"));
        $id = "488fcbd5-eb82-42dc-8a2b-10fdf70e0bfe";
        $chargeObj = \CoinbaseCommerce\Resources\Charge::retrieve($id);
        $this->assertRequested("GET", "/charges/" . $id, "");
        $this->assertInstanceOf(\CoinbaseCommerce\Resources\Charge::getClassName(), $chargeObj);
        $this->assertEquals("7C7V5ECK", $chargeObj->code);
    }
    public function testListMethod()
    {
        $this->appendRequest(200, $this->parseJsonFile("chargeList.json"));
        $chargeList = \CoinbaseCommerce\Resources\Charge::getList(["limit" => 2]);
        $this->assertRequested("GET", "/charges", "limit=2");
        $this->assertInstanceOf(\CoinbaseCommerce\ApiResourceList::getClassName(), $chargeList);
    }
    public function testAllMethod()
    {
        $firstPageChargeList = $this->parseJsonFile("firstPageChargeList.json");
        $startingAfter = $firstPageChargeList["pagination"]["cursor_range"][1];
        $this->appendRequest(200, $firstPageChargeList);
        $this->appendRequest(200, $this->parseJsonFile("secondPageChargeList.json"));
        $list = \CoinbaseCommerce\Resources\Charge::getAll(["order" => "desc"]);
        $this->assertRequested("GET", "/charges", "order=desc");
        $this->assertRequested("GET", "/charges", "order=desc&starting_after=" . $startingAfter);
        $this->assertCount(3, $list);
        $this->assertInstanceOf(\CoinbaseCommerce\Resources\Charge::getClassName(), $list[0]);
    }
}

?>