<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace CoinbaseCommerce\Tests;

class ExceptionsTest extends BaseTest
{
    protected $fixtures = [];
    public function getFixtures()
    {
        if(empty($this->fixtures)) {
            $this->fixtures = [["response" => ["statusCode" => 400, "body" => ["error" => ["type" => "invalid_request", "message" => "Pricing type is not included in the list"]]], "exceptionClass" => \CoinbaseCommerce\Exceptions\InvalidRequestException::getClassName()], ["response" => ["statusCode" => 401, "body" => ["error" => ["type" => "authorization_error", "message" => "You are not authorized to do that."]]], "exceptionClass" => \CoinbaseCommerce\Exceptions\AuthenticationException::getClassName()], ["response" => ["statusCode" => 404, "body" => ["error" => ["type" => "not_found", "message" => "Not foun"]]], "exceptionClass" => \CoinbaseCommerce\Exceptions\ResourceNotFoundException::getClassName()], ["response" => ["statusCode" => 429, "body" => ["error" => ["type" => "rate_limit_exceeded", "message" => "Rate limit exceeded"]]], "exceptionClass" => \CoinbaseCommerce\Exceptions\RateLimitExceededException::getClassName()], ["response" => ["statusCode" => 500, "body" => ["error" => ["type" => "internal_server_error", "message" => "Internal server error"]]], "exceptionClass" => \CoinbaseCommerce\Exceptions\InternalServerException::getClassName()], ["response" => ["statusCode" => 503, "body" => ""], "exceptionClass" => \CoinbaseCommerce\Exceptions\ServiceUnavailableException::getClassName()], ["response" => ["statusCode" => 500, "body" => ["error" => ["type" => "internal_server_error", "message" => "Internal server error"]]], "exceptionClass" => \CoinbaseCommerce\Exceptions\InternalServerException::getClassName()], ["response" => ["statusCode" => 400, "body" => ["error" => ["type" => "validation_error", "message" => "Validation error"]]], "exceptionClass" => \CoinbaseCommerce\Exceptions\ValidationException::getClassName()], ["response" => ["statusCode" => 400, "body" => ["error" => ["type" => "param_required", "message" => "Validation error"]]], "exceptionClass" => \CoinbaseCommerce\Exceptions\ParamRequiredException::getClassName()], ["response" => ["statusCode" => 502, "body" => ""], "exceptionClass" => \CoinbaseCommerce\Exceptions\ApiException::getClassName()]];
        }
        return $this->fixtures;
    }
    public function testApiExceptions()
    {
        \CoinbaseCommerce\Resources\Charge::setClient($this->apiClient);
        foreach ($this->getFixtures() as $fixture) {
            try {
                $this->appendRequest($fixture["response"]["statusCode"], $fixture["response"]["body"]);
                \CoinbaseCommerce\Resources\Charge::create(["name" => "Test Name", "description" => "Test Description"]);
            } catch (\Exception $exception) {
                $this->assertInstanceOf($fixture["exceptionClass"], $exception);
                $this->assertEquals($fixture["response"]["statusCode"], $exception->getCode());
            }
        }
    }
}

?>