<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace CoinbaseCommerce\Tests;

class BaseTest extends \PHPUnit\Framework\TestCase
{
    protected $apiClient;
    protected $httpClientWrapper;
    protected $logger;
    public function setUp()
    {
        $this->initMockClient();
        parent::setUp();
    }
    public function initMockClient()
    {
        $this->httpClientWrapper = GuzzleClientMock\GuzzleMockClientFactoryMethod::create();
        $client = $this->httpClientWrapper->getClient();
        $this->apiClient = $this->getMockBuilder(\CoinbaseCommerce\ApiClient::getClassName())->disableOriginalConstructor()->disableOriginalClone()->setMethods(["getHttpClient"])->getMock();
        $this->apiClient->method("getHttpClient")->willReturn($client);
        $this->logger = $this->getMockBuilder("LoggerClass")->setMethods(["warning"])->getMock("LoggerClass");
        $this->logger->method("warning")->willReturnArgument(0);
        $this->apiClient->init("test_key");
        $this->apiClient->setLogger($this->logger);
    }
    public function appendRequest($statusCode, $body, $headers = [])
    {
        $this->httpClientWrapper->appendRequest($statusCode, $body, $headers);
    }
    public function parseJsonFile($file)
    {
        $filePath = __DIR__ . DIRECTORY_SEPARATOR . "Fixtures" . DIRECTORY_SEPARATOR . $file;
        if(!file_exists($filePath)) {
            throw new \Exception("File not exists");
        }
        $data = file_get_contents($filePath);
        return json_decode($data, true);
    }
    public function assertRequested($method, $path, $params = "")
    {
        $request = $this->httpClientWrapper->shiftTransactionRequest();
        $this->assertEquals($method, $request["method"]);
        $this->assertEquals($path, $request["path"]);
        $this->assertEquals($params, $request["params"]);
    }
}

?>