<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace CoinbaseCommerce\Resources\Operations;

trait UpdateMethodTrait
{
    public function update($headers = [])
    {
        $id = $this->getPrimaryKeyValue();
        if(!is_scalar($id) || NULL === $id) {
            throw new \Exception("id is not set.");
        }
        $client = static::getClient();
        $path = \CoinbaseCommerce\Util::joinPath(static::getResourcePath(), $id);
        $body = $this->getDirtyAttributes();
        unset($body[$this::getPrimaryKeyName()]);
        $response = $client->put($path, $body, $headers);
        $this->refreshFrom($response);
    }
    public static function updateById($id, $body, $headers = [])
    {
        if(!is_scalar($id)) {
            throw new \Exception("Invalid id provided.");
        }
        unset($body[static::getPrimaryKeyName()]);
        $path = \CoinbaseCommerce\Util::joinPath(static::getResourcePath(), $id);
        $client = static::getClient();
        $response = $client->put($path, $body, $headers);
        return \CoinbaseCommerce\Util::convertToApiObject($response);
    }
}

?>