<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace CoinbaseCommerce;

class ApiResourceList extends \ArrayObject
{
    protected $items = [];
    protected $pagination = [];
    protected $resourceClass;
    protected $headers = [];
    protected $params = [];
    private static $apiClient;
    const CURSOR_PARAM = "cursor_range";
    const PREV_CURSOR = "ending_before";
    const NEXT_CURSOR = "starting_after";
    public function __construct($resourceClass, $items, $pagination, $params, $headers)
    {
        $this->resourceClass = $resourceClass;
        $this->items = $items;
        $this->pagination = $pagination;
        $this->params = $params;
        $this->headers = $headers;
    }
    public function setItems($items)
    {
        $this->items = $items;
    }
    public function setPagination($pagination)
    {
        $this->pagination = $pagination;
    }
    public function getPagination()
    {
        return $this->pagination;
    }
    public function getParams()
    {
        return $this->params;
    }
    public function hasNext()
    {
        return isset($this->pagination[self::CURSOR_PARAM][1]) && NULL !== $this->pagination[self::CURSOR_PARAM][1];
    }
    public function loadNext()
    {
        if(!$this->hasNext()) {
            return false;
        }
        $nextCursor = $this->pagination[self::CURSOR_PARAM][1];
        $params = $this->getParams();
        $params[self::NEXT_CURSOR] = $nextCursor;
        $this->loadPage($params);
        return true;
    }
    public function hasPrev()
    {
        return isset($this->pagination[self::CURSOR_PARAM][0]) && NULL !== $this->pagination[self::CURSOR_PARAM][0];
    }
    public function loadPrev()
    {
        if(!$this->hasPrev()) {
            return false;
        }
        $prevCursor = $this->pagination[self::CURSOR_PARAM][0];
        $params = $this->getParams();
        $params[self::PREV_CURSOR] = $prevCursor;
        $this->loadPage($params);
        return true;
    }
    protected function loadPage($params)
    {
        $client = self::getClient();
        $resourceClass = $this->resourceClass;
        $path = $resourceClass::getResourcePath();
        $response = $client->get($path, $params, $this->headers);
        $responseData = $response->bodyArray;
        $this->pagination = isset($responseData["pagination"]) ? $responseData["pagination"] : [];
        $this->items = [];
        if(isset($responseData["data"])) {
            $this->items = array_map(function ($item) {
                return Util::convertToApiObject($item);
            }, $responseData["data"]);
        }
    }
    public function offsetGet($key)
    {
        return $this->items[$key];
    }
    public function offsetSet($key, $value)
    {
        NULL === $key ? array_push($this->items, $value) : $this->items[$key];
    }
    public function count()
    {
        return count($this->items);
    }
    public function countAll()
    {
        if(isset($this->pagination["total"])) {
            return $this->pagination["total"];
        }
    }
    public function asort()
    {
        asort($this->items);
    }
    public function ksort()
    {
        ksort($this->items);
    }
    public function offsetUnset($key)
    {
        unset($this->items[$key]);
    }
    public function getIterator()
    {
        return new \ArrayIterator($this->items);
    }
    public static function getClient()
    {
        if(self::$apiClient) {
            return self::$apiClient;
        }
        return ApiClient::getInstance();
    }
    public function setClient($client)
    {
        self::$apiClient = $client;
    }
    public static function getClassName()
    {
        return get_called_class();
    }
}

?>