<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace CoinbaseCommerce;

class ApiClient
{
    private $params;
    private static $instance;
    private $logger;
    private $response;
    private $httpClient;
    const API_KEY_PARAM = "apiKey";
    const BASE_API_URL_PARAM = "baseApiUrl";
    const API_VERSION_PARAM = "apiVersion";
    const TIMEOUT_PARAM = "timeout";
    private function __construct()
    {
    }
    private function __clone()
    {
    }
    public static function init($apiKey, $baseUrl = NULL, $apiVersion = NULL, $timeout = NULL)
    {
        if(!self::$instance) {
            self::$instance = new self();
        }
        self::$instance->setApiKey($apiKey)->setBaseUrl($baseUrl)->setApiVersion($apiVersion)->setTimeout($timeout);
        return self::$instance;
    }
    public static function getInstance()
    {
        if(!self::$instance) {
            throw new \Exception("Please init client first.");
        }
        return self::$instance;
    }
    private function getParam($key)
    {
        if(array_key_exists($key, $this->params)) {
            return $this->params[$key];
        }
    }
    private function setParam($key, $value)
    {
        $this->params[$key] = $value;
        return $this;
    }
    public function setApiKey($value)
    {
        if(empty($value)) {
            throw new \Exception("Api Key is required");
        }
        $this->setParam(self::API_KEY_PARAM, $value);
        return $this;
    }
    public function getApiKey()
    {
        return $this->getParam(self::API_KEY_PARAM);
    }
    public function setBaseUrl($value)
    {
        if(!empty($value) && is_string($value)) {
            if(substr($value, -1) !== "/") {
                $value .= "/";
            }
            $this->setParam(self::BASE_API_URL_PARAM, $value);
        }
        return $this;
    }
    public function getBaseUrl()
    {
        return $this->getParam(self::BASE_API_URL_PARAM);
    }
    public function setApiVersion($value)
    {
        if(!empty($value) && is_string($value)) {
            $this->setParam(self::API_VERSION_PARAM, $value);
        }
        return $this;
    }
    public function getApiVersion()
    {
        return $this->getParam(self::API_VERSION_PARAM);
    }
    public function setTimeout($value)
    {
        if(!empty($value) && is_numeric($value)) {
            $this->setParam(self::TIMEOUT_PARAM, $value);
        }
        return $this;
    }
    public function getTimeout()
    {
        return $this->getParam(self::TIMEOUT_PARAM);
    }
    private function generateRequestOptions($query = [], $body = [], $headers = [])
    {
        return $options = ["headers" => array_merge(["Content-Type" => "application/json", "Accept" => "application/json", "User-Agent" => "Coinbase ", "X-CC-Api-Key" => $this->getParam("apiKey"), "X-CC-Version" => $this->getParam("apiVersion")], $headers), "query" => $query, "json" => $body, "timeout" => $this->getParam("timeout")];
    }
    private function makeRequest($method, $path, $options)
    {
        try {
            $path = Util::joinPath($this->getParam("baseApiUrl"), $path);
            $client = $this->getHttpClient();
            if(method_exists($client, "createRequest")) {
                $request = $client->createRequest($method, $path, $options);
                $response = $client->send($request);
            } else {
                $response = $client->request($method, $path, $options);
            }
            $apiResponse = new ApiResponse($response);
            $this->setLastResponse($apiResponse);
            $this->logWarnings($apiResponse);
            return $apiResponse;
        } catch (\GuzzleHttp\Exception\RequestException $exception) {
            throw ApiErrorFactory::create($exception);
        }
    }
    public function getHttpClient()
    {
        if(!isset($this->httpClient)) {
            $this->httpClient = new \GuzzleHttp\Client();
        }
        return $this->httpClient;
    }
    public function setLogger($logger)
    {
        $this->logger = $logger;
    }
    public function get($path, $queryParams = [], $headers = [])
    {
        $options = $this->generateRequestOptions($queryParams, $headers);
        return $this->makeRequest("GET", $path, $options);
    }
    public function post($path, $body, $headers)
    {
        $options = $this->generateRequestOptions([], $body, $headers = []);
        return $this->makeRequest("POST", $path, $options);
    }
    public function put($path, $body, $headers)
    {
        $options = $this->generateRequestOptions([], $body, $headers = []);
        return $this->makeRequest("PUT", $path, $options);
    }
    public function delete($path, $headers = [])
    {
        $options = $this->generateRequestOptions([], [], $headers);
        return $this->makeRequest("DELETE", $path, $options);
    }
    public function setLastResponse($response)
    {
        $this->response = $response;
    }
    public function getLastResponse()
    {
        return $this->response;
    }
    public function logWarnings($response)
    {
        if(!$this->logger) {
            return NULL;
        }
        $data = $response->bodyArray;
        if(!isset($data["warnings"])) {
            return NULL;
        }
        foreach ($data["warnings"] as $warning) {
            $this->logger->warning(is_array($warning) ? implode(",", $warning) : $warning);
        }
    }
    public static function getClassName()
    {
        return get_called_class();
    }
}

?>