<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
require_once __DIR__ . "/vendor/autoload.php";
CoinbaseCommerce\ApiClient::init("API_KEY");
$chargeObj = new CoinbaseCommerce\Resources\Charge(["description" => "Mastering the Transition to the Information Age", "metadata" => ["customer_id" => "id_1005", "customer_name" => "Satoshi Nakamoto"], "name" => "Test Name", "payments" => [], "pricing_type" => "no_price"]);
try {
    $chargeObj->save();
    echo sprintf("Successfully created new charge with id: %s \n", $chargeObj->id);
} catch (Exception $exception) {
    echo sprintf("Enable to create charge. Error: %s \n", $exception->getMessage());
}
if($chargeObj->id) {
    $chargeObj->description = "New description";
    try {
        $chargeObj->refresh();
        echo sprintf("Successfully refreshed checkout.\n");
    } catch (Exception $exception) {
        echo sprintf("Enable to refresh checkout. Error: %s \n", $exception->getMessage());
    }
    try {
        $retrievedCharge = CoinbaseCommerce\Resources\Charge::retrieve($chargeObj->id);
        echo sprintf("Successfully retrieved charge\n");
        echo $retrievedCharge;
    } catch (Exception $exception) {
        echo sprintf("Enable to retrieve charge. Error: %s \n", $exception->getMessage());
    }
}
try {
    $list = CoinbaseCommerce\Resources\Charge::getList(["limit" => 5]);
    echo sprintf("Successfully got list of charges\n");
    if(count($list)) {
        echo sprintf("Charges in list:\n");
        foreach ($list as $charge) {
            echo $charge;
        }
    }
    echo sprintf("List's pagination:\n");
    print_r($list->getPagination());
    echo sprintf("Number of all charges - %s \n", $list->countAll());
} catch (Exception $exception) {
    echo sprintf("Enable to get list of charges. Error: %s \n", $exception->getMessage());
}
if(isset($list) && $list->hasNext()) {
    try {
        $list->loadNext();
        echo sprintf("Next page of charges: \n");
        foreach ($list as $charge) {
            echo $charge;
        }
    } catch (Exception $exception) {
        echo sprintf("Enable to get new page of charges. Error: %s \n", $exception->getMessage());
    }
}
try {
    $allCharge = CoinbaseCommerce\Resources\Charge::getAll();
    echo sprintf("Successfully got all charges:\n");
    foreach ($allCharge as $charge) {
        echo $charge;
    }
} catch (Exception $exception) {
    echo sprintf("Enable to get all charges. Error: %s \n", $exception->getMessage());
}

?>